/*
 * Decompiled with CFR 0.152.
 */
package com.github.fnar.minecraft.item;

import com.github.fnar.minecraft.item.ItemType;
import com.github.fnar.minecraft.item.RldBaseItem;
import com.github.fnar.minecraft.item.RldItemStack;
import java.util.Objects;

public class Material
extends RldBaseItem {
    private final Type type;

    public Material(Type type) {
        this.type = type;
    }

    public static Material clayBall() {
        return new Material(Type.CLAY_BALL);
    }

    @Override
    public ItemType getItemType() {
        return ItemType.MATERIAL;
    }

    public Type getMaterialType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Material material = (Material)o;
        return this.type == material.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    public static enum Type {
        BONE,
        BOOK,
        CLAY_BALL,
        COAL,
        DIAMOND,
        EMERALD,
        FEATHER,
        FLINT,
        GOLD_INGOT,
        GOLD_NUGGET,
        IRON_INGOT,
        IRON_NUGGET,
        LEATHER,
        PAPER,
        SLIME_BALL,
        SNOWBALL,
        STICK,
        STRING,
        WHEAT;


        public Material asItem() {
            return new Material(this);
        }

        public RldItemStack asItemStack() {
            return this.asItem().asStack();
        }
    }
}

